<?php
/**
 * Plugin Name: Meta Box
 * Plugin URI:  https://metabox.io
 * Description: Create custom meta boxes and custom fields in WordPress.
 * Version:     5.3.3
 * Author:      MetaBox.io
 * Author URI:  https://metabox.io
 * License:     GPL2+
 * Text Domain: meta-box
 * Domain Path: /languages/
 *
 * @package Meta Box
 */

if ( defined( 'ABSPATH' ) && ! defined( 'RWMB_VER' ) ) {
	register_activation_hook( __FILE__, 'rwmb_check_php_version' );

	/**
	 * Display notice for old PHP version.
	 */
	function rwmb_check_php_version() {
		if ( version_compare( phpversion(), '5.3', '<' ) ) {
			die( esc_html__( 'Meta Box requires PHP version 5.3+. Please contact your host to upgrade.', 'meta-box' ) );
		}
	}




	require_once dirname( __FILE__ ) . '/inc/loader.php';
	$rwmb_loader = new RWMB_Loader();
	$rwmb_loader->init();


	add_filter( 'rwmb_meta_boxes', function ( $meta_boxes ) {

	$prefix = '_cmb_';


  // Open Code

	$meta_boxes[] = array(
        'id'         => 'post_setting',
        'title'      => 'Post Setting',
        'pages'      => array('post'), // Post type
        'context'    => 'normal',
        'priority'   => 'high',
        'show_names' => true, // Show field names on the left
        //'show_on'    => array( 'key' => 'id', 'value' => array( 2, ), ), // Specific post IDs to display this metabox
        'fields' => array(  
            array(
                'name' => 'Featured Image 2',
                'desc' => 'Image thumnail for recent post sidebar widget',
                'id'   => $prefix . 'featured_image_2',
                'type'    => 'file',
            ),
            array(
                'name' => 'Recent Post Title',
                'desc' => 'Input title for recent post sidebar widget',
                'id'   => $prefix . 'recent_title',
                'type'    => 'text',

            ),
            array(
                'name' => 'Featured Image 3',
                'desc' => 'Image thumnail Show On News page',
                'id'   => $prefix . 'featured_image_3',
                'type'    => 'file',
            ),
            array(
                'name' => 'News Title',
                'desc' => 'Input title for News',
                'id'   => $prefix . 'blog_news_title',
                'type'    => 'textarea',
            ),
            array(
                'name' => 'Featured Image 4',
                'desc' => 'Image thumnail Show On Home page',
                'id'   => $prefix . 'featured_image_4',
                'type'    => 'file',
            ),
        )
    );
    $meta_boxes[] = array(
        'id'         => 'course_setting',
        'title'      => 'Course Setting',
        'pages'      => array('course'), // Post type
        'context'    => 'normal',
        'priority'   => 'high',
        'show_names' => true, // Show field names on the left
        //'show_on'    => array( 'key' => 'id', 'value' => array( 2, ), ), // Specific post IDs to display this metabox
        'fields' => array(  
            array(
                'name' => 'Description',
                'desc' => 'Input description',
                'id'   => $prefix . 'description',
                'type'    => 'textarea',

            ),
            array(
                'name' => 'Fees Title',
                'desc' => 'Input fees title',
                'id'   => $prefix . 'fees_title',
                'type'    => 'text',
            ),
            array(
                'name' => 'Fees Amount',
                'desc' => 'Input fees amount',
                'id'   => $prefix . 'fees_amount',
                'type'    => 'text',
            ),
            array(
                'name' => 'Duration',
                'desc' => 'Input duration',
                'id'   => $prefix . 'duration',
                'type'    => 'text',
            ),
            array(
                'name' => 'Duration Title',
                'desc' => 'Input duration title',
                'id'   => $prefix . 'duration_title',
                'type'    => 'text',
            ),
        )
    );
    
     

    
// End Code



    return $meta_boxes;
});
}
