<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsCourseDescription extends \Elementor\Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Elementor widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'bdevs-course-description';
    }

    /**
     * Get widget title.
     *
     * Retrieve Bdevs Elementor widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Course Description', 'bdevs-elementor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve Bdevs About widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-post-list';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Bdevs About widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'bdevs-elementor' ];
    }

    public function get_keywords() {
        return [ 'course description' ];
    }

    public function get_script_depends() {
        return [ 'bdevs-elementor'];
    }

    // BDT Position
    protected function element_pack_position() {
        $position_options = [
            ''              => esc_html__('Default', 'bdevs-elementor'),
            'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
            'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
            'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
            'center'        => esc_html__('Center', 'bdevs-elementor') ,
            'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
            'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
            'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
            'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
            'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
        ];

        return $position_options;
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_content_heading',
            [
                'label' => esc_html__( 'Course Description', 'bdevs-elementor' ),
            ]   
        );
        $this->add_control(
          'course_image',
          [
            'label'   => esc_html__( 'Course Image', 'bdevs-elementor' ),
            'type'    => Controls_Manager::MEDIA,
            'dynamic' => [ 'active' => true ],
            'description' => esc_html__( 'Add image from here', 'bdevs-elementor' ),
          ]
        );
        $this->add_control(
            'heading',
            [
                'label'       => __( 'Heading:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
                'default'     => __( 'This is heading', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );  
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter your content', 'bdevs-elementor' ),
                'default'     => __( 'This is content', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'shortcode',
            [
                'label'   => esc_html__( 'Shortcode:', 'bdevs-elementor' ),
                'type'    => Controls_Manager::TEXT,
                'dynamic' => [ 'active' => true ],
                'default'       => __('Contact Shortcode here', 'bdevs-elementor'),
                'description' => esc_html__( 'Add Your shortcode here', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'duration_icon',
            [
                'label'       => __( 'Duration Icon:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your icon', 'bdevs-elementor' ),
                'default'     => __( 'icon-duration-icon', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'duration',
            [
                'label'       => __( 'Duration:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your duration', 'bdevs-elementor' ),
                'default'     => __( '<span>Duration</span> 2 YEAR', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'eligible_icon',
            [
                'label'       => __( 'Eligible Icon:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your icon', 'bdevs-elementor' ),
                'default'     => __( 'icon-eligibility-icon', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'eligible',
            [
                'label'       => __( 'Eligible:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter your eligible', 'bdevs-elementor' ),
                'default'     => __( '<span>ELIGIBILITY:</span> Graduation/DBA/<br>
              Diploma/Equivalent', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'fee',
            [
                'label'       => __( 'Course Fee:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter your fee', 'bdevs-elementor' ),
                'default'     => __( '<span>COURSE FEE:</span> $2500 ', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'link_button',
            [
                'label'       => __( 'Link Button:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter link button', 'bdevs-elementor' ),
                'default'     => __( '#' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button',
            [
                'label'       => __( 'Button:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter button', 'bdevs-elementor' ),
                'default'     => __( 'apply now <span class="icon-more-icon"></span>' ),
                'label_block' => true,
            ]
        );
        $this->end_controls_section();
        /** 
        *   Layout section 
        **/
        $this->start_controls_section(
            'section_content_layout',
            [
                'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
            ]
        );
        $this->add_responsive_control(
            'align',
            [
                'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-justify',
                    ],
                ],
                'prefix_class' => 'elementor%s-align-',
                'description'  => 'Use align to match position',
                'default'      => 'left',
            ]
        );
        $this->add_control(
            'show_heading',
            [
                'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );  
        $this->end_controls_section();

    }

    public function render() {
    $settings  = $this->get_settings_for_display();
    extract($settings); ?>  
    <!-- Start Course Description -->
    <section class="about inner padding-lg">
        <div class="container">
            <div class="row">
                <div class="col-md-7 col-md-push-5 left-block">
                    <?php if ( $settings['show_heading'] ) : ?>
                    <h2><?php print wp_kses_post($settings['heading']); ?></h2>
                    <?php endif; ?> 
                    <p><?php print wp_kses_post($settings['content']); ?></p>
                </div>
                <div class="col-md-5 col-md-pull-7">
                    <div class="enquire-wrapper">
                        <figure class="hidden-xs hidden-sm"><img src="<?php echo esc_url($settings['course_image']['url']); ?>" class="img-responsive" alt=""></figure>
                        <?php print do_shortcode(html_entity_decode( $settings['shortcode'] )); ?> 
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <div class="course-detail clearfix">
                        <?php if(isset($settings['duration']) && $settings['duration'] != ''){?>
                        <div class="duration clearfix">
                            
                            <div class="icon"><span class="<?php print wp_kses_post($settings['duration_icon']); ?>"></span></div>
                            <div class="detail"> <?php print wp_kses_post($settings['duration']); ?> </div>
                            
                        </div>
                        <?php } ?>
                        <?php if(isset($settings['eligible']) && $settings['eligible'] != ''){?>
                        <div class="duration eligible clearfix">
                            <div class="icon"><span class="<?php print wp_kses_post($settings['eligible_icon']); ?>"></span></div>
                            <div class="detail"> <?php print wp_kses_post($settings['eligible']); ?></div>
                        </div>
                        <?php } ?>
                        <?php if(isset($settings['fee']) && $settings['fee'] != ''){?>
                        <div class="duration fee clearfix">
                            <div class="detail"> <?php print wp_kses_post($settings['fee']); ?> </div>
                        </div>
                        <?php } ?>
                        <?php if(isset($settings['link_button']) && $settings['link_button'] != ''){?>
                        <a href="<?php print wp_kses_post($settings['link_button']); ?>" class="btn"><?php print wp_kses_post($settings['button']); ?></a> 
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- End Course Description --> 
    <?php
    }

}


