<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* Region File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\Networkaccess\Model;

use Microsoft\Graph\Core\Enum;

/**
* Region class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class Region extends Enum
{
    /**
    * The Enum Region
    */
    const EAST_US = "eastUS";
    const EAST_US2 = "eastUS2";
    const WEST_US = "westUS";
    const WEST_US2 = "westUS2";
    const WEST_US3 = "westUS3";
    const CENTRAL_US = "centralUS";
    const NORTH_CENTRAL_US = "northCentralUS";
    const SOUTH_CENTRAL_US = "southCentralUS";
    const NORTH_EUROPE = "northEurope";
    const WEST_EUROPE = "westEurope";
    const FRANCE_CENTRAL = "franceCentral";
    const GERMANY_WEST_CENTRAL = "germanyWestCentral";
    const SWITZERLAND_NORTH = "switzerlandNorth";
    const UK_SOUTH = "ukSouth";
    const CANADA_EAST = "canadaEast";
    const CANADA_CENTRAL = "canadaCentral";
    const SOUTH_AFRICA_WEST = "southAfricaWest";
    const SOUTH_AFRICA_NORTH = "southAfricaNorth";
    const UAE_NORTH = "uaeNorth";
    const UNKNOWN_FUTURE_VALUE = "unknownFutureValue";
}
