<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsAboutVideo extends \Elementor\Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Elementor widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'bdevs-about-video';
    }

    /**
     * Get widget title.
     *
     * Retrieve Bdevs Elementor widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'About Video', 'bdevs-elementor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve Bdevs About widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-youtube';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Bdevs About widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'bdevs-elementor' ];
    }

    public function get_keywords() {
        return [ 'about video' ];
    }

    public function get_script_depends() {
        return [ 'bdevs-elementor'];
    }

    // BDT Position
    protected function element_pack_position() {
        $position_options = [
            ''              => esc_html__('Default', 'bdevs-elementor'),
            'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
            'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
            'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
            'center'        => esc_html__('Center', 'bdevs-elementor') ,
            'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
            'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
            'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
            'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
            'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
        ];

        return $position_options;
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_content_heading',
            [
                'label' => esc_html__( 'About Video', 'bdevs-elementor' ),
            ]   
        );
        $this->add_control(
            'link_video',
            [
                'label'       => __( 'Link Video:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter link video', 'bdevs-elementor' ),
                'default'     => __( '#' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
          'background_video',
          [
            'label'   => esc_html__( 'Background Video Image', 'bdevs-elementor' ),
            'type'    => Controls_Manager::MEDIA,
            'dynamic' => [ 'active' => true ],
            'description' => esc_html__( 'Add image from here', 'bdevs-elementor' ),
          ]
        );
        $this->add_control(
          'button_image',
          [
            'label'   => esc_html__( 'Button Image', 'bdevs-elementor' ),
            'type'    => Controls_Manager::MEDIA,
            'dynamic' => [ 'active' => true ],
            'description' => esc_html__( 'Add image from here', 'bdevs-elementor' ),
          ]
        );
        $this->add_control(
            'icon_download_1',
            [
                'label'   => esc_html__( 'Icon Download 1', 'bdevs-elementor' ),
                'type'    => Controls_Manager::MEDIA,
                'dynamic' => [ 'active' => true ],
                'description' => esc_html__( 'Add image from here', 'bdevs-elementor' ),
            ]
        );
        $this->add_control(
            'link_download_1',
            [
                'label'       => __( 'Link Download 1:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter link download 1', 'bdevs-elementor' ),
                'default'     => __( '#' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'download_button_1',
            [
                'label'       => __( 'Download Button 1:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter download button 1', 'bdevs-elementor' ),
                'default'     => __( '<span class="sm-txt">Download</span> Prospects' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'icon_download_2',
            [
                'label'   => esc_html__( 'Icon Download 2', 'bdevs-elementor' ),
                'type'    => Controls_Manager::MEDIA,
                'dynamic' => [ 'active' => true ],
                'description' => esc_html__( 'Add image from here', 'bdevs-elementor' ),
            ]
        );
        $this->add_control(
            'link_download_2',
            [
                'label'       => __( 'Link Download 2:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter link download 2', 'bdevs-elementor' ),
                'default'     => __( '#' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'download_button_2',
            [
                'label'       => __( 'Download Button 2:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter download button 2', 'bdevs-elementor' ),
                'default'     => __( '<span class="sm-txt">Download</span> Certification' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'heading',
            [
                'label'       => __( 'Heading:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
                'default'     => __( 'This is heading', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );  
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter your content', 'bdevs-elementor' ),
                'default'     => __( 'This is content', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->end_controls_section();
        /** 
        *   Layout section 
        **/
        $this->start_controls_section(
            'section_content_layout',
            [
                'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
            ]
        );
        $this->add_responsive_control(
            'align',
            [
                'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-justify',
                    ],
                ],
                'prefix_class' => 'elementor%s-align-',
                'description'  => 'Use align to match position',
                'default'      => 'left',
            ]
        );
        $this->add_control(
            'show_heading',
            [
                'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );  
        $this->end_controls_section();

    }

    public function render() {
    $settings  = $this->get_settings_for_display();
    extract($settings); ?>  
    <!-- Start About Section -->
    <section class="about inner padding-lg">
        <div class="container">
            <div class="row">
                <div class="col-md-5">
                    <div class="video-block">
                        <div id="thumbnail_container"> 
                            <img src="<?php echo esc_url($settings['background_video']['url']); ?>" id="thumbnail" class="img-responsive" alt=""> 
                        </div>
                        <?php if(isset($settings['button_image']['url']) && $settings['button_image']['url'] != ''){?>
                        <a href="#" data-toggle="modal" data-target="#myModal" class="start-video">
                            <img src="<?php print wp_kses_post($settings['button_image']['url']); ?>" alt=""></a>
                          <?php } ?> 
                        <!-- Modal -->
                        <div class="modal fade" id="myModal" tabindex="-1" role="dialog">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                    <div class="modal-body">
                                        <div class="video-block">
                                            <iframe width="560" height="315" src="<?php print wp_kses_post($settings['link_video']); ?>" allowfullscreen></iframe>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="btn-wrapper clearfix">
                        <?php if(isset($settings['link_download_1']) && $settings['link_download_1'] != ''){?> 
                        <a href="<?php print wp_kses_post($settings['link_download_1']); ?>" class="download-pros"> 
                            <span class="ico-block">
                                <img src="<?php echo wp_kses_post($settings['icon_download_1']['url']); ?>" alt="download prospects">
                            </span> 
                            <span class="txt-block"> 
                                <?php print wp_kses_post($settings['download_button_1']); ?> 
                            </span> 
                        </a> 
                        <?php } ?>
                        <?php if(isset($settings['link_download_2']) && $settings['link_download_2'] != ''){?>
                        <a href="<?php print wp_kses_post($settings['link_download_2']); ?>" class="download-cert"> 
                            <span class="ico-block">
                                <img src="<?php echo wp_kses_post($settings['icon_download_2']['url']); ?>" alt="certification">
                            </span> 
                            <span class="txt-block"> 
                                <?php print wp_kses_post($settings['download_button_2']); ?>
                            </span> 
                        </a> 
                        <?php } ?>
                    </div>
                </div>
                <div class="col-md-7 left-block">
                    <?php if ( $settings['show_heading'] ) : ?>
                    <h2><?php print wp_kses_post($settings['heading']); ?></h2>
                    <?php endif; ?>
                    <?php if(isset($settings['content']) && $settings['content'] != ''){?> 
                    <p><?php print wp_kses_post($settings['content']); ?></p>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
    <!-- End About Section --> 
    <?php
    }

}


